/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class MapMultChain
extends Lop {
    public static final String OPCODE = Opcodes.MAPMMCHAIN.toString();
    public static final String OPCODE_CP = Opcodes.MMCHAIN.toString();
    private ChainType _chainType = null;
    private int _numThreads = 1;

    public MapMultChain(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        super(Lop.Type.MapMultChain, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        this._chainType = ChainType.XtXv;
        this.setupLopProperties(et);
    }

    public MapMultChain(Lop input1, Lop input2, Lop input3, ChainType chain, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        super(Lop.Type.MapMultChain, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        this.addInput(input3);
        input1.addOutput(this);
        input2.addOutput(this);
        input3.addOutput(this);
        this._chainType = chain;
        this.setupLopProperties(et);
    }

    public void setNumThreads(int k) {
        this._numThreads = k;
    }

    @Override
    public String toString() {
        return "Operation = MapMMChain";
    }

    @Override
    public Lop getBroadcastInput() {
        if (this.getExecType() != Types.ExecType.SPARK) {
            return null;
        }
        return this.getInputs().get(1);
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        return this.getInstructions(input1, input2, null, output);
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) {
        StringBuilder sb = InstructionUtils.getStringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        if (this.getExecType() == Types.ExecType.CP) {
            sb.append(OPCODE_CP);
        } else {
            sb.append(OPCODE);
        }
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        if (input3 != null) {
            sb.append("\u00b0");
            sb.append(this.getInputs().get(2).prepInputOperand(input3));
        }
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append((Object)this._chainType);
        if (this.getExecType() == Types.ExecType.CP) {
            sb.append("\u00b0");
            sb.append(this._numThreads);
        }
        return sb.toString();
    }

    public static enum ChainType {
        XtXv,
        XtwXv,
        XtXvy,
        NONE;


        public boolean isWeighted() {
            return this == XtwXv || this == XtXvy;
        }
    }
}

