/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor;

import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.parfor.ResultMergeLocalFile;
import org.apache.sysds.runtime.controlprogram.parfor.ResultMergeLocalMemory;
import org.apache.sysds.runtime.controlprogram.parfor.ResultMergeMatrix;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptimizerRuleBased;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.utils.stats.Timing;

public class ResultMergeLocalAutomatic
extends ResultMergeMatrix {
    private static final long serialVersionUID = 1600893100602101732L;
    private ResultMergeMatrix _rm = null;

    public ResultMergeLocalAutomatic(MatrixObject out, MatrixObject[] in, String outputFilename, boolean accum) {
        super(out, in, outputFilename, accum);
    }

    @Override
    public MatrixObject executeSerialMerge() {
        long cols;
        Timing time = new Timing(true);
        DataCharacteristics dc = ((MatrixObject)this._output).getDataCharacteristics();
        long rows = dc.getRows();
        this._rm = OptimizerRuleBased.isInMemoryResultMerge(rows, cols = dc.getCols(), OptimizerUtils.getLocalMemBudget()) ? new ResultMergeLocalMemory((MatrixObject)this._output, (MatrixObject[])this._inputs, this._outputFName, this._isAccum) : new ResultMergeLocalFile((MatrixObject)this._output, (MatrixObject[])this._inputs, this._outputFName, this._isAccum);
        MatrixObject ret = (MatrixObject)this._rm.executeSerialMerge();
        LOG.trace((Object)("Automatic result merge (" + this._rm.getClass().getName() + ") executed in " + time.stop() + "ms."));
        return ret;
    }

    @Override
    public MatrixObject executeParallelMerge(int par) {
        long cols;
        DataCharacteristics dc = ((MatrixObject)this._output).getDataCharacteristics();
        long rows = dc.getRows();
        this._rm = OptimizerRuleBased.isInMemoryResultMerge((long)par * rows, cols = dc.getCols(), OptimizerUtils.getLocalMemBudget()) ? new ResultMergeLocalMemory((MatrixObject)this._output, (MatrixObject[])this._inputs, this._outputFName, this._isAccum) : new ResultMergeLocalFile((MatrixObject)this._output, (MatrixObject[])this._inputs, this._outputFName, this._isAccum);
        return (MatrixObject)this._rm.executeParallelMerge(par);
    }
}

