/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.ListObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.io.FileFormatProperties;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.util.HDFSTool;

public class ListWriter {
    public static void writeListToHDFS(ListObject lo, String fname, String fmtStr, FileFormatProperties props) throws DMLRuntimeException {
        MatrixCharacteristics dc = new MatrixCharacteristics(lo.getLength(), 1L, 0, 0L);
        try {
            JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
            HDFSTool.writeMetaDataFile(fname + ".mtd", lo.getValueType(), null, lo.getDataType(), dc, Types.FileFormat.safeValueOf(fmtStr), props);
            HDFSTool.createDirIfNotExistOnHDFS(fname, "777");
            for (int i = 0; i < lo.getLength(); ++i) {
                Data dat = lo.getData(i);
                String lfname = fname + "/" + i + "_" + (lo.isNamedList() ? lo.getName(i) : "null");
                if (dat instanceof CacheableData) {
                    ((CacheableData)dat).exportData(lfname, fmtStr, props);
                    IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(job, new Path(lfname));
                    continue;
                }
                if (dat instanceof ListObject) {
                    ListWriter.writeListToHDFS((ListObject)dat, lfname, fmtStr, props);
                    continue;
                }
                HDFSTool.writeScalarToHDFS((ScalarObject)dat, lfname);
            }
            IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(job, new Path(fname));
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Failed to write list object of length " + ((DataCharacteristics)dc).getRows() + ".", ex);
        }
    }
}

