/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.offset;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.colgroup.AOffsetsGroup;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffsetByte;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffsetIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetByteNZ;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetByteUNZ;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class OffsetByte
extends AOffsetByte {
    private static final long serialVersionUID = -4716104973912491790L;
    protected static final int maxV = 255;
    private final int size;

    protected OffsetByte(byte[] offsets, int offsetToFirst, int offsetToLast, int size) {
        super(offsets, offsetToFirst, offsetToLast);
        this.size = size;
        if (CompressedMatrixBlock.debug) {
            this.toString();
        }
    }

    protected static AOffsetByte create(byte[] offsets, int offsetToFirst, int offsetToLast, int size, boolean noZero, boolean ub) {
        if (noZero) {
            if (ub) {
                return new OffsetByteUNZ(offsets, offsetToFirst, offsetToLast);
            }
            return new OffsetByteNZ(offsets, offsetToFirst, offsetToLast);
        }
        return new OffsetByte(offsets, offsetToFirst, offsetToLast, size);
    }

    @Override
    public AIterator getIterator() {
        return new IterateByteOffset();
    }

    @Override
    protected AIterator getIteratorFromIndexOff(int row, int dataIndex, int offIdx) {
        return new IterateByteOffset(offIdx, dataIndex, row);
    }

    @Override
    public AOffsetIterator getOffsetIterator() {
        return new OffsetByteIterator();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        byte[] its = new byte[17];
        its[0] = (byte)OffsetFactory.OFF_TYPE_SPECIALIZATIONS.BYTE.ordinal();
        IOUtilFunctions.intToBa(this.offsetToFirst, its, 1);
        IOUtilFunctions.intToBa(this.offsets.length, its, 5);
        IOUtilFunctions.intToBa(this.offsetToLast, its, 9);
        IOUtilFunctions.intToBa(this.size, its, 13);
        out.write(its);
        out.write(this.offsets);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 17 + this.offsets.length;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public long getInMemorySize() {
        return OffsetByte.estimateInMemorySize(this.offsets.length);
    }

    public static long estimateInMemorySize(int nOffs) {
        long size = 36L;
        size = (long)((double)size + MemoryEstimates.byteArrayCost(nOffs));
        return size;
    }

    public static OffsetByte readFields(DataInput in) throws IOException {
        int offsetToFirst = in.readInt();
        int offsetsLength = in.readInt();
        int offsetToLast = in.readInt();
        int size = in.readInt();
        byte[] offsets = new byte[offsetsLength];
        in.readFully(offsets);
        return new OffsetByte(offsets, offsetToFirst, offsetToLast, size);
    }

    @Override
    public AOffset.OffsetSliceInfo slice(int lowOff, int highOff, int lowValue, int highValue, int low, int high) {
        int newSize = high - low + 1;
        byte[] newOffsets = Arrays.copyOfRange(this.offsets, lowOff, highOff);
        OffsetByte off = new OffsetByte(newOffsets, lowValue, highValue, newSize);
        return new AOffset.OffsetSliceInfo(low, high + 1, off);
    }

    @Override
    public AOffset moveIndex(int m) {
        return new OffsetByte(this.offsets, this.offsetToFirst - m, this.offsetToLast - m, this.size);
    }

    @Override
    public final AOffset appendN(AOffsetsGroup[] g, int s) {
        for (AOffsetsGroup gs : g) {
            AOffset a = gs.getOffsets();
            if (a instanceof OffsetByte) continue;
            return super.appendN(g, s);
        }
        int totalLength = g[0].getOffsets().getLength();
        for (int i = 1; i < g.length; ++i) {
            totalLength += g[i].getOffsets().getLength() + 1;
            int remainder = s - g[i - 1].getOffsets().getOffsetToLast();
            totalLength += (remainder + g[i].getOffsets().getOffsetToFirst() - 1) / 255;
        }
        byte[] ret = new byte[totalLength];
        int p = 0;
        int remainderLast = 0;
        int size = 0;
        boolean first = true;
        for (AOffsetsGroup gs : g) {
            OffsetByte b = (OffsetByte)gs.getOffsets();
            if (!first) {
                int offFirst = remainderLast + b.offsetToFirst;
                int div = offFirst / 255;
                int mod = offFirst % 255;
                if (mod == 0) {
                    p += div - 1;
                    ret[p++] = -1;
                } else {
                    p += div;
                    ret[p++] = (byte)mod;
                }
            }
            byte[] bd = b.offsets;
            System.arraycopy(bd, 0, ret, p, bd.length);
            remainderLast = s - b.offsetToLast;
            size += b.size;
            p += bd.length;
            first = false;
        }
        int offLast = s * (g.length - 1) + g[g.length - 1].getOffsets().getOffsetToLast();
        return new OffsetByte(ret, this.offsetToFirst, offLast, size);
    }

    private class OffsetByteIterator
    extends AOffsetIterator {
        protected int index;

        private OffsetByteIterator() {
            super(OffsetByte.this.offsetToFirst);
            this.index = 0;
        }

        @Override
        public int next() {
            byte v = OffsetByte.this.offsets[this.index];
            while (v == 0) {
                this.offset += 255;
                ++this.index;
                v = OffsetByte.this.offsets[this.index];
            }
            ++this.index;
            return this.offset += v & 0xFF;
        }
    }

    private class IterateByteOffset
    extends AIterator {
        protected int index;
        protected int dataIndex;

        private IterateByteOffset() {
            super(OffsetByte.this.offsetToFirst);
            this.index = 0;
            this.dataIndex = 0;
        }

        private IterateByteOffset(int index, int dataIndex, int offset) {
            super(offset);
            this.index = index;
            this.dataIndex = dataIndex;
        }

        @Override
        public int next() {
            byte v = OffsetByte.this.offsets[this.index];
            while (v == 0) {
                this.offset += 255;
                ++this.index;
                v = OffsetByte.this.offsets[this.index];
            }
            this.offset += v & 0xFF;
            ++this.index;
            ++this.dataIndex;
            return this.offset;
        }

        @Override
        public int skipTo(int idx) {
            if (idx < OffsetByte.this.offsetToLast) {
                while (this.offset < idx) {
                    this.next();
                }
            } else {
                while (this.offset < idx && this.index < OffsetByte.this.offsets.length) {
                    this.next();
                }
            }
            return this.offset;
        }

        @Override
        public IterateByteOffset clone() {
            return new IterateByteOffset(this.index, this.dataIndex, this.offset);
        }

        @Override
        public int getDataIndex() {
            return this.dataIndex;
        }

        @Override
        public int getOffsetsIndex() {
            return this.index;
        }
    }
}

