/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.offset;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffsetByte;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffsetIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class OffsetByteUNZ
extends AOffsetByte {
    private static final long serialVersionUID = -4716104973912299990L;

    protected OffsetByteUNZ(byte[] offsets, int offsetToFirst, int offsetToLast) {
        super(offsets, offsetToFirst, offsetToLast);
        if (CompressedMatrixBlock.debug) {
            this.toString();
        }
    }

    @Override
    public AIterator getIterator() {
        return new IterateByteOffsetNoOverHalf();
    }

    @Override
    protected AIterator getIteratorFromIndexOff(int row, int dataIndex, int offIdx) {
        return new IterateByteOffsetNoOverHalf(dataIndex, row);
    }

    @Override
    public AOffsetIterator getOffsetIterator() {
        return new OffsetByteIteratorNoOverHalf();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        byte[] its = new byte[13];
        its[0] = (byte)OffsetFactory.OFF_TYPE_SPECIALIZATIONS.BYTEUNZ.ordinal();
        IOUtilFunctions.intToBa(this.offsetToFirst, its, 1);
        IOUtilFunctions.intToBa(this.offsets.length, its, 5);
        IOUtilFunctions.intToBa(this.offsetToLast, its, 9);
        out.write(its);
        out.write(this.offsets);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 13 + this.offsets.length;
    }

    @Override
    public int getSize() {
        return this.offsets.length + 1;
    }

    @Override
    public long getInMemorySize() {
        return OffsetByteUNZ.estimateInMemorySize(this.offsets.length);
    }

    public static long estimateInMemorySize(int nOffs) {
        long size = 32L;
        size = (long)((double)size + MemoryEstimates.byteArrayCost(nOffs));
        return size;
    }

    public static AOffsetByte readFields(DataInput in) throws IOException {
        int offsetToFirst = in.readInt();
        int offsetsLength = in.readInt();
        int offsetToLast = in.readInt();
        byte[] offsets = new byte[offsetsLength];
        in.readFully(offsets);
        return new OffsetByteUNZ(offsets, offsetToFirst, offsetToLast);
    }

    @Override
    public AOffset.OffsetSliceInfo slice(int lowOff, int highOff, int lowValue, int highValue, int low, int high) {
        byte[] newOffsets = Arrays.copyOfRange(this.offsets, lowOff, highOff);
        OffsetByteUNZ off = new OffsetByteUNZ(newOffsets, lowValue, highValue);
        return new AOffset.OffsetSliceInfo(low, high + 1, off);
    }

    @Override
    public AOffset moveIndex(int m) {
        return new OffsetByteUNZ(this.offsets, this.offsetToFirst - m, this.offsetToLast - m);
    }

    private class OffsetByteIteratorNoOverHalf
    extends AOffsetIterator {
        protected int index;

        private OffsetByteIteratorNoOverHalf() {
            super(OffsetByteUNZ.this.offsetToFirst);
            this.index = 0;
        }

        @Override
        public int next() {
            return this.offset += OffsetByteUNZ.this.offsets[this.index++];
        }
    }

    private class IterateByteOffsetNoOverHalf
    extends AIterator {
        protected int index;

        private IterateByteOffsetNoOverHalf() {
            super(OffsetByteUNZ.this.offsetToFirst);
        }

        private IterateByteOffsetNoOverHalf(int index, int offset) {
            super(offset);
            this.index = index;
        }

        @Override
        public final int next() {
            this.offset += OffsetByteUNZ.this.offsets[this.index];
            ++this.index;
            return this.offset;
        }

        @Override
        public final int skipTo(int idx) {
            while (this.offset < idx && this.index < OffsetByteUNZ.this.offsets.length) {
                this.offset += OffsetByteUNZ.this.offsets[this.index];
                ++this.index;
            }
            return this.offset;
        }

        @Override
        public int getDataIndex() {
            return this.index;
        }

        @Override
        public int getOffsetsIndex() {
            return this.index;
        }

        @Override
        public final IterateByteOffsetNoOverHalf clone() {
            return new IterateByteOffsetNoOverHalf(this.index, this.offset);
        }
    }
}

