/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.lib.CLALibSeparator;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.util.CommonThreadPool;

public final class CLALibStack {
    protected static final Log LOG = LogFactory.getLog((String)CLALibStack.class.getName());

    private CLALibStack() {
    }

    public static MatrixBlock combine(Map<MatrixIndexes, MatrixBlock> m, Map<Integer, List<IDictionary>> d, int k) {
        MatrixIndexes lookup = new MatrixIndexes(1L, 1L);
        MatrixBlock b = m.get(lookup);
        int blen = Math.max(b.getNumColumns(), b.getNumRows());
        long rows = CLALibStack.findRLength(m, b);
        long cols = CLALibStack.findCLength(m, b);
        return CLALibStack.combine(m, d, lookup, (int)rows, (int)cols, blen, k);
    }

    public static MatrixBlock combine(Map<MatrixIndexes, MatrixBlock> m, Map<Integer, List<IDictionary>> d, int rlen, int clen, int blen, int k) {
        MatrixIndexes lookup = new MatrixIndexes();
        return CLALibStack.combine(m, d, lookup, rlen, clen, blen, k);
    }

    private static long findRLength(Map<MatrixIndexes, MatrixBlock> m, MatrixBlock b) {
        MatrixIndexes lookup = new MatrixIndexes(1L, 1L);
        long rows = 0L;
        while ((b = m.get(lookup)) != null) {
            rows += (long)b.getNumRows();
            lookup.setIndexes(lookup.getRowIndex() + 1L, 1L);
        }
        return rows;
    }

    private static long findCLength(Map<MatrixIndexes, MatrixBlock> m, MatrixBlock b) {
        MatrixIndexes lookup = new MatrixIndexes(1L, 1L);
        long cols = 0L;
        while ((b = m.get(lookup)) != null) {
            cols += (long)b.getNumColumns();
            lookup.setIndexes(1L, lookup.getColumnIndex() + 1L);
        }
        return cols;
    }

    private static MatrixBlock combine(Map<MatrixIndexes, MatrixBlock> m, Map<Integer, List<IDictionary>> d, MatrixIndexes lookup, int rlen, int clen, int blen, int k) {
        try {
            return CLALibStack.combineColumnGroups(m, d, lookup, rlen, clen, blen, k);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to combine compressed blocks, fallback to decompression.", (Throwable)e);
            return CLALibStack.combineViaDecompression(m, rlen, clen, blen, k);
        }
    }

    private static MatrixBlock combineViaDecompression(Map<MatrixIndexes, MatrixBlock> m, int rlen, int clen, int blen, int k) {
        MatrixBlock out = new MatrixBlock(rlen, clen, false);
        out.allocateDenseBlock();
        for (Map.Entry<MatrixIndexes, MatrixBlock> e : m.entrySet()) {
            MatrixIndexes ix = e.getKey();
            MatrixBlock block = e.getValue();
            if (block == null) continue;
            int row_offset = (int)(ix.getRowIndex() - 1L) * blen;
            int col_offset = (int)(ix.getColumnIndex() - 1L) * blen;
            block.putInto(out, row_offset, col_offset, false);
        }
        out.setNonZeros(-1L);
        out.examSparsity(true);
        return out;
    }

    private static MatrixBlock combineColumnGroups(Map<MatrixIndexes, MatrixBlock> m, Map<Integer, List<IDictionary>> d, MatrixIndexes lookup, int rlen, int clen, int blen, int k) {
        int nGroups = 0;
        int bc = 0;
        while (bc * blen < clen) {
            lookup.setIndexes(1L, bc + 1);
            CompressedMatrixBlock cmb = (CompressedMatrixBlock)m.get(lookup);
            List<AColGroup> gs = cmb.getColGroups();
            nGroups += gs.size();
            ++bc;
        }
        int blocksInColumn = rlen / blen + (rlen % blen > 0 ? 1 : 0);
        AColGroup[][] finalCols = new AColGroup[nGroups][blocksInColumn];
        int br = 0;
        while (br * blen < rlen) {
            int cgid = 0;
            int bc2 = 0;
            while (bc2 * blen < clen) {
                lookup.setIndexes(br + 1, bc2 + 1);
                CompressedMatrixBlock cmb = (CompressedMatrixBlock)m.get(lookup);
                if (cmb == null) {
                    throw new RuntimeException("Invalid empty read: " + lookup + "  " + rlen + " " + clen + " " + blen);
                }
                List<AColGroup> gs = cmb.getColGroups();
                if (cgid + gs.size() > nGroups) {
                    return CLALibStack.combineViaDecompression(m, rlen, clen, blen, k);
                }
                for (int i = 0; i < gs.size(); ++i) {
                    AColGroup gc;
                    AColGroup g = gs.get(i);
                    finalCols[cgid][br] = gc = bc2 > 0 ? g.shiftColIndices(bc2 * blen) : g;
                    ++cgid;
                }
                ++bc2;
            }
            if (cgid != finalCols.length) {
                LOG.warn((Object)"Combining via decompression. The number of columngroups in each block is not identical");
                return CLALibStack.combineViaDecompression(m, rlen, clen, blen, k);
            }
            ++br;
        }
        ExecutorService pool = CommonThreadPool.get();
        try {
            List<AColGroup> finalGroups = pool.submit(() -> ((Stream)Arrays.stream(finalCols).parallel()).map(x -> {
                AColGroup r = AColGroup.appendN(x, blen, rlen);
                return r;
            }).collect(Collectors.toList())).get();
            if (finalGroups.contains(null)) {
                LOG.warn((Object)"Combining via decompression. There was a column group that did not append ");
                MatrixBlock matrixBlock = CLALibStack.combineViaDecompression(m, rlen, clen, blen, k);
                return matrixBlock;
            }
            if (d != null) {
                finalGroups = CLALibSeparator.combine(finalGroups, d, blen);
            }
            CompressedMatrixBlock compressedMatrixBlock = new CompressedMatrixBlock(rlen, clen, -1L, false, finalGroups);
            return compressedMatrixBlock;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new DMLRuntimeException("Failed to combine column groups", e);
        }
        finally {
            pool.shutdown();
        }
    }
}

