/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.parfor.DataPartitioner;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.IJV;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixCell;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.util.FastStringTokenizer;
import org.apache.sysds.runtime.util.LocalFileUtils;

public class DataPartitionerLocal
extends DataPartitioner {
    private static final boolean PARALLEL = true;
    private MatrixBlock _reuseBlk = null;
    private int _par = -1;

    public DataPartitionerLocal(ParForProgramBlock.PartitionFormat dpf, int par) {
        super(dpf._dpf, dpf._N);
        if (dpf.isBlockwise()) {
            throw new DMLRuntimeException("Data partitioning formt '" + dpf + "' not supported by DataPartitionerLocal");
        }
        this._par = par > 0 ? par : 1;
    }

    @Override
    protected void partitionMatrix(MatrixObject in, String fnameNew, Types.FileFormat fmt, long rlen, long clen, int blen) {
        in.exportData();
        String fname = in.getFileName();
        String fnameStaging = LocalFileUtils.getUniqueWorkingDir("partitioning");
        if (fmt != Types.FileFormat.BINARY) {
            throw new DMLRuntimeException("Cannot create data partitions of format: " + fmt.toString());
        }
        this.partitionBinaryBlock(fname, fnameStaging, fnameNew, rlen, clen, blen);
        LocalFileUtils.cleanupWorkingDirectory(fnameStaging);
    }

    private void partitionBinaryBlock(String fname, String fnameStaging, String fnameNew, long rlen, long clen, int blen) {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        try (FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);){
            this._reuseBlk = DataPartitioner.createReuseMatrixBlock(this._format, blen, blen);
            MatrixIndexes key = new MatrixIndexes();
            MatrixBlock value = new MatrixBlock();
            for (Path lpath : IOUtilFunctions.getSequenceFilePaths(fs, path)) {
                try (SequenceFile.Reader reader = new SequenceFile.Reader(fs, lpath, (Configuration)job);){
                    while (reader.next((Writable)key, (Writable)value)) {
                        long row_offset = (key.getRowIndex() - 1L) * (long)blen;
                        long col_offset = (key.getColumnIndex() - 1L) * (long)blen;
                        long rows = value.getNumRows();
                        long cols = value.getNumColumns();
                        if (row_offset + rows < 1L || row_offset + rows > rlen || col_offset + cols < 1L || col_offset + cols > clen) {
                            throw new IOException("Matrix block [" + (row_offset + 1L) + ":" + (row_offset + rows) + "," + (col_offset + 1L) + ":" + (col_offset + cols) + "] out of overall matrix range [1:" + rlen + ",1:" + clen + "].");
                        }
                        this.appendBlockToStagingArea(fnameStaging, value, row_offset, col_offset, blen);
                    }
                }
            }
            String[] fnamesPartitions = new File(fnameStaging).list();
            int len = Math.min(fnamesPartitions.length, this._par);
            Thread[] threads = new Thread[len];
            for (int i = 0; i < len; ++i) {
                int start = i * (int)Math.ceil((double)fnamesPartitions.length / (double)len);
                int end = (i + 1) * (int)Math.ceil((double)fnamesPartitions.length / (double)len) - 1;
                end = Math.min(end, fnamesPartitions.length - 1);
                threads[i] = new Thread(new DataPartitionerWorkerBinaryBlock(job, fnameNew, fnameStaging, fnamesPartitions, start, end));
                threads[i].start();
            }
            for (Thread t : threads) {
                t.join();
            }
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Unable to partition binary block matrix.", e);
        }
    }

    private void appendBlockToStagingArea(String dir, MatrixBlock mb, long row_offset, long col_offset, long blen) throws IOException {
        boolean sparse = mb.isInSparseFormat();
        long nnz = mb.getNonZeros();
        long rows = mb.getNumRows();
        long cols = mb.getNumColumns();
        double sparsity = (double)nnz / (double)(rows * cols);
        if (this._format == ParForProgramBlock.PDataPartitionFormat.ROW_WISE) {
            this._reuseBlk.reset(1, (int)cols, sparse, (int)((double)cols * sparsity));
            int i = 0;
            while ((long)i < rows) {
                String pdir = LocalFileUtils.checkAndCreateStagingDir(dir + "/" + (row_offset + 1L + (long)i));
                String pfname = pdir + "/block_" + (col_offset / blen + 1L);
                mb.slice(i, i, 0, (int)(cols - 1L), this._reuseBlk);
                LocalFileUtils.writeMatrixBlockToLocal(pfname, this._reuseBlk);
                this._reuseBlk.reset();
                ++i;
            }
        } else if (this._format == ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE) {
            String pdir = LocalFileUtils.checkAndCreateStagingDir(dir + "/" + (row_offset / blen + 1L));
            String pfname = pdir + "/block_" + (col_offset / blen + 1L);
            LocalFileUtils.writeMatrixBlockToLocal(pfname, mb);
        } else if (this._format == ParForProgramBlock.PDataPartitionFormat.COLUMN_WISE) {
            this._reuseBlk.reset((int)rows, 1, false);
            int i = 0;
            while ((long)i < cols) {
                String pdir = LocalFileUtils.checkAndCreateStagingDir(dir + "/" + (col_offset + 1L + (long)i));
                String pfname = pdir + "/block_" + (row_offset / blen + 1L);
                mb.slice(0, (int)(rows - 1L), i, i, this._reuseBlk);
                LocalFileUtils.writeMatrixBlockToLocal(pfname, this._reuseBlk);
                this._reuseBlk.reset();
                ++i;
            }
        } else if (this._format == ParForProgramBlock.PDataPartitionFormat.COLUMN_BLOCK_WISE) {
            String pdir = LocalFileUtils.checkAndCreateStagingDir(dir + "/" + (col_offset / blen + 1L));
            String pfname = pdir + "/block_" + (row_offset / blen + 1L);
            LocalFileUtils.writeMatrixBlockToLocal(pfname, mb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBinaryBlockSequenceFileToHDFS(JobConf job, String dir, String lpdir, boolean threadsafe) throws IOException {
        long key = DataPartitionerLocal.getKeyFromFilePath(lpdir);
        Path path = new Path(dir + "/" + key);
        SequenceFile.Writer writer = IOUtilFunctions.getSeqWriter(path, (Configuration)job, 1);
        try {
            String[] fnameBlocks;
            for (String fnameBlock : fnameBlocks = new File(lpdir).list()) {
                long key2 = DataPartitionerLocal.getKey2FromFileName(fnameBlock);
                MatrixBlock tmp = null;
                tmp = threadsafe ? LocalFileUtils.readMatrixBlockFromLocal(lpdir + "/" + fnameBlock) : LocalFileUtils.readMatrixBlockFromLocal(lpdir + "/" + fnameBlock, this._reuseBlk);
                if (this._format == ParForProgramBlock.PDataPartitionFormat.ROW_WISE || this._format == ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE) {
                    writer.append((Writable)new MatrixIndexes(1L, key2), (Writable)tmp);
                    continue;
                }
                if (this._format != ParForProgramBlock.PDataPartitionFormat.COLUMN_WISE && this._format != ParForProgramBlock.PDataPartitionFormat.COLUMN_BLOCK_WISE) continue;
                writer.append((Writable)new MatrixIndexes(key2, 1L), (Writable)tmp);
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBinaryCellSequenceFileToHDFS(JobConf job, String dir, String lpdir) throws IOException {
        long key = DataPartitionerLocal.getKeyFromFilePath(lpdir);
        Path path = new Path(dir + "/" + key);
        SequenceFile.Writer writer = IOUtilFunctions.getSeqWriterCell(path, (Configuration)job, 1);
        try {
            String[] fnameBlocks;
            MatrixIndexes indexes = new MatrixIndexes();
            MatrixCell cell = new MatrixCell();
            for (String fnameBlock : fnameBlocks = new File(lpdir).list()) {
                LinkedList<IJV> tmp = DataPartitionerLocal.readCellListFromLocal(lpdir + "/" + fnameBlock);
                for (IJV c : tmp) {
                    indexes.setIndexes(c.getI(), c.getJ());
                    cell.setValue(c.getV());
                    writer.append((Writable)indexes, (Writable)cell);
                }
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
    }

    private static LinkedList<IJV> readCellListFromLocal(String fname) throws IOException {
        FileInputStream fis = new FileInputStream(fname);
        LinkedList<IJV> buffer = new LinkedList<IJV>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(fis));){
            String value = null;
            FastStringTokenizer st = new FastStringTokenizer(' ');
            while ((value = in.readLine()) != null) {
                st.reset(value);
                int row = (int)st.nextLong();
                int col = (int)st.nextLong();
                double lvalue = st.nextDouble();
                IJV c = new IJV().set(row, col, lvalue);
                buffer.addLast(c);
            }
        }
        return buffer;
    }

    private static long getKeyFromFilePath(String dir) {
        String[] dirparts = dir.split("/");
        long key = Long.parseLong(dirparts[dirparts.length - 1]);
        return key;
    }

    private static long getKey2FromFileName(String fname) {
        return Long.parseLong(fname.split("_")[1]);
    }

    private class DataPartitionerWorkerBinaryBlock
    extends DataPartitionerWorker {
        public DataPartitionerWorkerBinaryBlock(JobConf job, String fnameNew, String fnameStaging, String[] fnamesPartitions, int start, int end) {
            super(job, fnameNew, fnameStaging, fnamesPartitions, start, end);
        }

        @Override
        public void writeFileToHDFS(JobConf job, String fnameNew, String stagingDir) throws IOException {
            DataPartitionerLocal.this.writeBinaryBlockSequenceFileToHDFS(job, fnameNew, stagingDir, true);
        }
    }

    private abstract class DataPartitionerWorker
    implements Runnable {
        private JobConf _job = null;
        private String _fnameNew = null;
        private String _fnameStaging = null;
        private String[] _fnamesPartitions = null;
        private int _start = -1;
        private int _end = -1;

        public DataPartitionerWorker(JobConf job, String fnameNew, String fnameStaging, String[] fnamesPartitions, int start, int end) {
            this._job = job;
            this._fnameNew = fnameNew;
            this._fnameStaging = fnameStaging;
            this._fnamesPartitions = fnamesPartitions;
            this._start = start;
            this._end = end;
        }

        @Override
        public void run() {
            try {
                for (int i = this._start; i <= this._end; ++i) {
                    String pdir = this._fnamesPartitions[i];
                    this.writeFileToHDFS(this._job, this._fnameNew, this._fnameStaging + "/" + pdir);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed on parallel data partitioning.", ex);
            }
        }

        public abstract void writeFileToHDFS(JobConf var1, String var2, String var3) throws IOException;
    }
}

