/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockMCSR;
import org.apache.sysds.runtime.data.SparseRow;
import org.apache.sysds.runtime.io.FileFormatPropertiesCOG;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.MatrixReader;
import org.apache.sysds.runtime.io.cog.COGByteReader;
import org.apache.sysds.runtime.io.cog.COGCompressionUtils;
import org.apache.sysds.runtime.io.cog.COGHeader;
import org.apache.sysds.runtime.io.cog.COGProperties;
import org.apache.sysds.runtime.io.cog.SampleFormatDataTypes;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class ReaderCOGParallel
extends MatrixReader {
    protected final FileFormatPropertiesCOG _props;
    private final int _numThreads;

    public ReaderCOGParallel(FileFormatPropertiesCOG props) {
        this._props = props;
        this._numThreads = OptimizerUtils.getParallelBinaryReadParallelism();
    }

    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        BufferedInputStream bis = new BufferedInputStream((InputStream)fs.open(path));
        return this.readCOG(bis, estnnz);
    }

    @Override
    public MatrixBlock readMatrixFromInputStream(InputStream is, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        BufferedInputStream bis = new BufferedInputStream(is);
        return this.readCOG(bis, estnnz);
    }

    private MatrixBlock readCOG(BufferedInputStream bis, long estnnz) throws IOException {
        COGByteReader byteReader = new COGByteReader(bis);
        COGHeader cogHeader = COGHeader.readCOGHeader(byteReader);
        String isCompatible = COGHeader.isCompatible(cogHeader.getIFD());
        if (!isCompatible.equals("")) {
            throw new DMLRuntimeException("Incompatible COG file: " + isCompatible);
        }
        COGProperties cogP = new COGProperties(cogHeader.getIFD());
        int tileCols = cogP.getCols() / cogP.getTileWidth();
        int tileRows = cogP.getRows() / cogP.getTileLength();
        int calculatedAmountTiles = tileCols * tileRows;
        int actualAmountTiles = cogP.getTileOffsets().length;
        int currentTileCol = 0;
        int currentTileRow = 0;
        int currentBand = 0;
        ExecutorService pool = CommonThreadPool.get(this._numThreads);
        MatrixBlock outputMatrix = ReaderCOGParallel.createOutputMatrixBlock(cogP.getRows(), cogP.getCols() * cogP.getBands(), cogP.getRows(), estnnz, false, true);
        boolean tilesFullySequential = cogP.tilesFullySequential();
        try {
            ArrayList<TileProcessor> tasks = new ArrayList<TileProcessor>();
            for (int currenTileIdx = 0; currenTileIdx < actualAmountTiles; ++currenTileIdx) {
                TileProcessor tileProcessor;
                long bytesToRead = (long)cogP.getTileOffsets()[currenTileIdx] - byteReader.getTotalBytesRead() + (long)cogP.getBytesPerTile()[currenTileIdx];
                if (!tilesFullySequential) {
                    byteReader.mark(bytesToRead);
                }
                byteReader.skipBytes((long)cogP.getTileOffsets()[currenTileIdx] - byteReader.getTotalBytesRead());
                byte[] currentTileData = byteReader.readBytes(cogP.getBytesPerTile()[currenTileIdx]);
                if (!tilesFullySequential) {
                    byteReader.reset();
                }
                if (cogP.getCompression() == 8) {
                    currentTileData = COGCompressionUtils.decompressDeflate(currentTileData);
                }
                if (cogP.getPlanarConfiguration() == 1) {
                    tileProcessor = new TileProcessor(cogP.getCols() * cogP.getBands(), currentTileData, currentTileRow, currentTileCol, cogP.getTileWidth(), cogP.getTileLength(), cogP.getBands(), cogP.getBitsPerSample(), cogP.getSampleFormat(), cogHeader, outputMatrix, cogP.getPlanarConfiguration());
                    if (++currentTileCol >= tileCols) {
                        currentTileCol = 0;
                        ++currentTileRow;
                    }
                } else if (cogP.getPlanarConfiguration() == 2) {
                    if (currenTileIdx - currentBand * calculatedAmountTiles >= calculatedAmountTiles) {
                        currentTileCol = 0;
                        currentTileRow = 0;
                        ++currentBand;
                    }
                    tileProcessor = new TileProcessor(cogP.getCols() * cogP.getBands(), currentTileData, currentTileRow, currentTileCol, cogP.getTileWidth(), cogP.getTileLength(), cogP.getBands(), cogP.getBitsPerSample(), cogP.getSampleFormat(), cogHeader, outputMatrix, cogP.getPlanarConfiguration(), currentBand);
                    if (++currentTileCol >= tileCols) {
                        currentTileCol = 0;
                        ++currentTileRow;
                    }
                } else {
                    throw new DMLRuntimeException("Unsupported Planar Configuration: " + cogP.getPlanarConfiguration());
                }
                tasks.add(tileProcessor);
            }
            try {
                for (Future result : pool.invokeAll(tasks)) {
                    result.get();
                }
                if (outputMatrix.isInSparseFormat()) {
                    ReaderCOGParallel.sortSparseRowsParallel(outputMatrix, cogP.getRows(), this._numThreads, pool);
                }
            }
            catch (Exception e) {
                throw new IOException("Error during parallel task execution.", e);
            }
        }
        catch (IOException e) {
            throw new IOException("Thread pool issue or file reading error.", e);
        }
        finally {
            pool.shutdown();
        }
        outputMatrix.examSparsity();
        return outputMatrix;
    }

    public class TileProcessor
    implements Callable<MatrixBlock> {
        private final int clen;
        private final byte[] tileData;
        private final int tileRow;
        private final int tileCol;
        private final int tileWidth;
        private final int tileLength;
        private final int bands;
        private final int[] bitsPerSample;
        private final SampleFormatDataTypes[] sampleFormat;
        private final COGHeader cogHeader;
        private final MatrixBlock _dest;
        private final int planarConfiguration;
        private final boolean sparse;
        private final int band;

        public TileProcessor(int clen, byte[] tileData, int tileRow, int tileCol, int tileWidth, int tileLength, int bands, int[] bitsPerSample, SampleFormatDataTypes[] sampleFormat, COGHeader cogHeader, MatrixBlock dest, int planarConfiguration) {
            this(clen, tileData, tileRow, tileCol, tileWidth, tileLength, bands, bitsPerSample, sampleFormat, cogHeader, dest, planarConfiguration, 0);
        }

        public TileProcessor(int clen, byte[] tileData, int tileRow, int tileCol, int tileWidth, int tileLength, int bands, int[] bitsPerSample, SampleFormatDataTypes[] sampleFormat, COGHeader cogHeader, MatrixBlock dest, int planarConfiguration, int band) {
            this.clen = clen;
            this.tileData = tileData;
            this.tileRow = tileRow;
            this.tileCol = tileCol;
            this.tileWidth = tileWidth;
            this.tileLength = tileLength;
            this.bands = bands;
            this.bitsPerSample = bitsPerSample;
            this.sampleFormat = sampleFormat;
            this.cogHeader = cogHeader;
            this._dest = dest;
            this.planarConfiguration = planarConfiguration;
            this.sparse = this._dest.isInSparseFormat();
            this.band = band;
        }

        @Override
        public MatrixBlock call() throws Exception {
            if (this.planarConfiguration == 1) {
                this.processTileByPixel();
            } else if (this.planarConfiguration == 2) {
                this.processTileByBand();
            } else {
                throw new DMLRuntimeException("Unsupported Planar Configuration: " + this.planarConfiguration);
            }
            return this._dest;
        }

        private void processTileByPixel() {
            int pixelsRead = 0;
            int bytesRead = 0;
            int currentRow = 0;
            MatrixBlock tileMatrix = new MatrixBlock(this.tileLength, this.tileWidth * this.bands, this.sparse);
            if (this.sparse) {
                tileMatrix.allocateAndResetSparseBlock(true, SparseBlock.Type.CSR);
                tileMatrix.getSparseBlock().allocate(0, this.tileLength * this.tileWidth * this.bands);
            }
            while (currentRow < this.tileLength && pixelsRead < this.tileWidth) {
                for (int bandIdx = 0; bandIdx < this.bands; ++bandIdx) {
                    double value = 0.0;
                    int sampleLength = this.bitsPerSample[bandIdx] / 8;
                    switch (this.sampleFormat[bandIdx]) {
                        case UNSIGNED_INTEGER: 
                        case UNDEFINED: {
                            value = this.cogHeader.parseByteArray(this.tileData, sampleLength, bytesRead, false, false, false).doubleValue();
                            break;
                        }
                        case SIGNED_INTEGER: {
                            value = this.cogHeader.parseByteArray(this.tileData, sampleLength, bytesRead, false, true, false).doubleValue();
                            break;
                        }
                        case FLOATING_POINT: {
                            value = this.cogHeader.parseByteArray(this.tileData, sampleLength, bytesRead, true, false, false).doubleValue();
                        }
                    }
                    bytesRead += sampleLength;
                    tileMatrix.set(currentRow, pixelsRead * this.bands + bandIdx, value);
                }
                if (++pixelsRead < this.tileWidth) continue;
                pixelsRead = 0;
                ++currentRow;
            }
            try {
                int rowOffset = this.tileRow * this.tileLength;
                int colOffset = this.tileCol * this.tileWidth * this.bands;
                if (this.sparse) {
                    this.insertIntoSparse(this._dest, tileMatrix, rowOffset, colOffset);
                } else {
                    this._dest.copy(rowOffset, rowOffset + this.tileLength - 1, colOffset, colOffset + this.tileWidth * this.bands - 1, tileMatrix, false);
                }
            }
            catch (RuntimeException e) {
                throw new DMLRuntimeException("Error while processing tile", e);
            }
        }

        private void processTileByBand() {
            int pixelsRead = 0;
            int bytesRead = 0;
            int currentRow = 0;
            MatrixBlock tileMatrix = new MatrixBlock(this.tileLength, this.tileWidth * this.bands, this.sparse);
            if (this.sparse) {
                tileMatrix.allocateAndResetSparseBlock(true, SparseBlock.Type.CSR);
                tileMatrix.getSparseBlock().allocate(0, this.tileLength * this.tileWidth * this.bands);
            }
            while (currentRow < this.tileLength && pixelsRead < this.tileWidth) {
                double value = 0.0;
                int sampleLength = this.bitsPerSample[this.band] / 8;
                switch (this.sampleFormat[this.band]) {
                    case UNSIGNED_INTEGER: 
                    case UNDEFINED: {
                        value = this.cogHeader.parseByteArray(this.tileData, sampleLength, bytesRead, false, false, false).doubleValue();
                        break;
                    }
                    case SIGNED_INTEGER: {
                        value = this.cogHeader.parseByteArray(this.tileData, sampleLength, bytesRead, false, true, false).doubleValue();
                        break;
                    }
                    case FLOATING_POINT: {
                        value = this.cogHeader.parseByteArray(this.tileData, sampleLength, bytesRead, true, false, false).doubleValue();
                    }
                }
                bytesRead += sampleLength;
                tileMatrix.set(currentRow, pixelsRead * this.bands + this.band, value);
                if (++pixelsRead < this.tileWidth) continue;
                pixelsRead = 0;
                ++currentRow;
            }
            try {
                int rowOffset = this.tileRow * this.tileLength;
                int colOffset = this.tileCol * this.tileWidth * this.bands;
                if (this.sparse) {
                    this.insertIntoSparse(this._dest, tileMatrix, rowOffset, colOffset);
                } else {
                    for (int i = 0; i < this.tileLength; ++i) {
                        for (int j = 0; j < this.tileWidth * this.bands; ++j) {
                            if (tileMatrix.get(i, j) == 0.0) continue;
                            this._dest.set(rowOffset + i, colOffset + j, tileMatrix.get(i, j));
                        }
                    }
                }
            }
            catch (RuntimeException e) {
                throw new DMLRuntimeException("Error while processing tile", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void insertIntoSparse(MatrixBlock _dest, MatrixBlock tileMatrix, int rowOffset, int colOffset) {
            SparseBlock sblock = _dest.getSparseBlock();
            if (this.tileWidth < this.clen) {
                if (sblock instanceof SparseBlockMCSR && sblock.get(rowOffset) != null) {
                    for (int i = 0; i < this.tileLength; ++i) {
                        SparseRow sparseRow = sblock.get(rowOffset + i);
                        synchronized (sparseRow) {
                            _dest.appendRowToSparse(sblock, tileMatrix, i, rowOffset, colOffset, true);
                            continue;
                        }
                    }
                } else {
                    MatrixBlock matrixBlock = _dest;
                    synchronized (matrixBlock) {
                        _dest.appendToSparse(tileMatrix, rowOffset, colOffset);
                    }
                }
            } else {
                _dest.appendToSparse(tileMatrix, rowOffset, colOffset);
            }
        }
    }
}

