/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common.sps;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.common.sps.BlockMovementStatus;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlockMovementAttemptFinished {
    private final Block block;
    private final DatanodeInfo src;
    private final DatanodeInfo target;
    private final StorageType targetType;
    private final BlockMovementStatus status;

    public BlockMovementAttemptFinished(Block block, DatanodeInfo src, DatanodeInfo target, StorageType targetType, BlockMovementStatus status) {
        this.block = block;
        this.src = src;
        this.target = target;
        this.targetType = targetType;
        this.status = status;
    }

    public Block getBlock() {
        return this.block;
    }

    public DatanodeInfo getTargetDatanode() {
        return this.target;
    }

    public StorageType getTargetType() {
        return this.targetType;
    }

    public BlockMovementStatus getStatus() {
        return this.status;
    }

    public String toString() {
        return "Block movement attempt finished(\n  " + " block : " + this.block + " src node: " + this.src + " target node: " + this.target + " target type: " + this.targetType + " movement status: " + (Object)((Object)this.status) + ")";
    }
}

