/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDChoiceButton;

public class PDCheckbox
extends PDChoiceButton {
    private static final COSName KEY = COSName.getPDFName("AS");
    private static final COSName OFF_VALUE = COSName.getPDFName("Off");

    public PDCheckbox(PDAcroForm theAcroForm, COSDictionary field) {
        super(theAcroForm, field);
    }

    public boolean isChecked() {
        String v = this.getDictionary().getNameAsString("V");
        if (v == null) {
            return false;
        }
        return v.compareTo(this.getOnValue()) == 0;
    }

    public void check() {
        this.setValue(this.getOnValue());
    }

    public void unCheck() {
        this.setValue(OFF_VALUE.getName());
    }

    @Override
    public void setValue(String newValue) {
        this.getDictionary().setName("V", newValue);
        List<PDAnnotationWidget> widgets = this.getWidgets();
        for (PDAnnotationWidget widget : widgets) {
            if (newValue == null) {
                widget.getDictionary().setItem(KEY, (COSBase)OFF_VALUE);
                continue;
            }
            widget.getDictionary().setName(KEY, newValue);
        }
    }

    public String getOffValue() {
        return OFF_VALUE.getName();
    }

    public String getOnValue() {
        List<PDAnnotationWidget> widgets = this.getWidgets();
        for (PDAnnotationWidget widget : widgets) {
            COSDictionary ap = (COSDictionary)widget.getDictionary().getDictionaryObject(COSName.getPDFName("AP"));
            widget.getDictionary().setItem(KEY, (COSBase)COSName.getPDFName("Yes"));
            COSBase n = ap.getDictionaryObject(COSName.getPDFName("N"));
            if (!(n instanceof COSDictionary)) continue;
            for (COSName key : ((COSDictionary)n).keySet()) {
                if (key.equals(OFF_VALUE)) continue;
                return key.getName();
            }
        }
        return null;
    }

    @Override
    public String getValue() throws IOException {
        return this.getDictionary().getNameAsString("V");
    }
}

