/*
 * Decompiled with CFR 0.152.
 */
package pax;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import pax.Constants;
import pax.EntryWriteException;

public class Entry
implements Constants {
    protected Writer out;
    protected String cmd;
    protected List args;
    protected Map kvs;
    protected boolean withKV;
    protected List delayedList;

    public Entry(Writer writer) {
        this.out = writer;
        this.cmd = null;
        this.args = new Vector();
        this.kvs = null;
        this.withKV = false;
        this.delayedList = new Vector();
    }

    public void clear() {
        this.cmd = null;
        this.args.clear();
        this.kvs = null;
        this.withKV = false;
    }

    public void setCmd(String string) {
        this.clear();
        this.cmd = string;
    }

    public String getCmd() {
        return this.cmd;
    }

    public void withKV() {
        this.withKV = true;
        if (this.kvs == null) {
            this.kvs = new HashMap();
        }
    }

    public void addArg(String string) {
        this.args.add(string);
    }

    public void putKV(String string, String string2) {
        this.withKV();
        if (string2 == null) {
            return;
        }
        this.kvs.put(string, string2);
    }

    public boolean isEmptyKV() {
        return !this.withKV || this.kvs.isEmpty();
    }

    public void writeDelayed() throws EntryWriteException {
        Writer writer = this.out;
        try {
            this.out = new StringWriter();
            this.write();
            this.delayedList.add(this.out.toString());
        }
        catch (Exception exception) {
            throw new EntryWriteException(exception);
        }
        finally {
            this.out = writer;
        }
    }

    public void write() throws EntryWriteException {
        try {
            this.out.write("\\[");
            this.out.write("{");
            this.out.write(this.cmd);
            this.out.write("}");
            for (String object : this.args) {
                this.out.write("{");
                this.out.write(object);
                this.out.write("}");
            }
            if (this.withKV) {
                if (this.kvs.isEmpty()) {
                    this.out.write("{}");
                } else {
                    this.out.write("{");
                    for (Map.Entry entry : this.kvs.entrySet()) {
                        String string = (String)entry.getKey();
                        String string2 = (String)entry.getValue();
                        this.out.write("\n  ");
                        this.out.write("");
                        this.out.write(string);
                        this.out.write("");
                        if (string2 != null) {
                            this.out.write("={");
                            this.out.write(string2);
                            this.out.write("}");
                        }
                        this.out.write(",");
                    }
                    this.out.write("\n}");
                }
            }
            this.out.write("\\\\\n");
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new EntryWriteException(iOException);
        }
        finally {
            this.clear();
        }
    }

    public void flushDelayed() throws EntryWriteException {
        try {
            Iterator iterator = this.delayedList.iterator();
            while (iterator.hasNext()) {
                this.out.write((String)iterator.next());
            }
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new EntryWriteException(iOException);
        }
    }

    public void close() throws EntryWriteException {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            throw new EntryWriteException(iOException);
        }
    }
}

